import app from "@system.app";

export default {
    onCreate() {
        console.log(JSON.stringify(app.getInfo(),321));
        console.info("Application onCreate");
        //发送一个手表应用已启动的事件给手机
        this.sendMsg({
            "eventFlg": "6",
        });
    },
    onDestroy() {
        console.info("Application onDestroy");
        //页面销毁，发送时间到手机，用于弹出断开连接弹窗
        this.sendMsg({
            "eventFlg": "7",
        });
        FeatureAbility.unsubscribeMsg();
    },

    //发送短消息给客户端
    sendMsg(obj) {
        FeatureAbility.sendMsg({
            deviceId: 'remote',
            bundleName: 'com.sportq.fit',
            abilityName: 'com.sportq.fit',
            message: JSON.stringify(obj),
            success: function () {
                console.log("发送成功")
            },
            fail: function (data, code) {
                console.log("发送失败")
            }
        });
    },
}


