import sensor from '@system.sensor'; //传感器
import vibrator from '@system.vibrator'; //震动
import brightness from '@system.brightness' //保持屏幕常亮

export default {
    data: {
        page: "", //显示页面
        title: "训练准备", //页面标题
        acName: " ", //动作名称
        progress: "", //进度条
        acType: "", //次/秒  (0:次，1：秒)
        acCnt: "00", //动作次数
        acTotalCnt: "00", // 动作总次数
        acCalorie: "", //卡路里
        countdownT: "", // 倒计时
        restHint: "", //休息文案
        isLast: "", //是否第一个动作 "0":真 "1":假
        isFirst: "", // 是否最后一个动作 "0":真 "1":假
        fitDuration: "", //训练持续时长
        fitTotalDuration: "", //训练时长-用于训练完成界面
        heartRateList: [], //心率数组
        averHeartRate: "", //平均心率
        maxHeartRate: "", //最高心率
        rollbackStop: "", //切出回来时候，是否需要暂停 "0":暂停 "0以外":切出训练
        newHeartRate: "--", //当前心率
        isStop: false, //是否暂停
        sendFlg: false, // 是否在发送消息
        stopFlg: false, //是否暂停
        tabIndex: 0, //滑动index
        isPhoneLeave: false, //手机端离开状态
        isEnd: false, //是否完成
        lastPage: "", //上个页面标识
        isReceiveStartMessage: false, //启动时收到手机端给的回复消息
    },
    onReady() {
        let _this = this;
        //数据重置
        _this.restore();
        //获取客户端信息
        _this.getMsg();
        //发送个启动事件
        _this.sendMsg({
            "eventFlg": "6",
        });
        //关闭启动页
        setTimeout(function () {
            if (!_this.isReceiveStartMessage) {
                _this.page = "12";
            }
        },1500);
    },
    onShow() {
        //保持屏幕常亮
        this.keepScreenOn();
    },
    onDestroy() {
        //发送页面销毁时间
        this.sendMsg({
            "eventFlg": "7",
        });
        this.quit();
        //取消接收手机侧第三方应用发过来的消息
        FeatureAbility.unsubscribeMsg();
    },
    start(msg) {
        let _this = this;
        let model = msg.acModel;

        //接到手机端消息时(去掉17初始化的事件)，启动页显示完后，不显示提示登录页面page 12
        if (msg.eventFlg != "") {
            if (msg.eventFlg == "17") {
                _this.page = "11";
            }
            _this.isReceiveStartMessage = true;
        }
        if (_this.sendFlg) {
            return false;
        }
        if (_this.isStop && msg.eventFlg != "7") {
            return false;
        }
        _this.isStop = false;

        //手机端主动离开事件，等待0.5秒后再处理其他事件
        if (_this.isPhoneLeave) {
            return
        }
        if (msg.eventFlg == "15" && model.rollbackStop != '0') {
            _this.isPhoneLeave = true;
            setTimeout(function () {
                _this.isPhoneLeave = false;
            },500)
        }
        //完成训练停止接受10、15事件
        if (_this.isEnd) {
            if (msg.eventFlg == "10" || msg.eventFlg == "15") {
                return false;
            }
        }
        switch (msg.eventFlg) {
            case "0": //训练准备
            _this.page = "0";
            _this.title = "训练准备";
            break;
            case "1": //训练准备后的倒计时
            _this.page = "1";
            _this.countdownT = model.countdownT;
            _this.isEnd = false;
            _this.stopFlg = false;
            break;
            case "2": //动作名称
            _this.vibrate();
            _this.page = "2";
            _this.acName = model.acName;
            _this.isLast = model.isLast;
            _this.isFirst = model.isFirst;
            break;
            case "3": //动作预览
            _this.page = "3";
            _this.acName = model.acName;
            break;
            case "4": //动作预览倒计时
            _this.page = "4";
            _this.acName = model.acName;
            _this.countdownT = model.countdownT;
            break;
            case "5": //训练动作倒计时
            _this.page = "5";
            _this.acName = model.acName;
            _this.countdownT = model.countdownT == "-1" ? "0" : model.countdownT;
            _this.acType = model.acType;
            if (model.acType == "0") {
                _this.acCnt = model.acCnt;
                _this.acTotalCnt = model.acTotalCnt;
            }
            break;
            case "6": //休息中
            _this.page = "6";
            _this.acName = model.acName;
            _this.countdownT = model.countdownT;
            _this.acType = 1;
            break;
            case "7": //暂停
            _this.tabIndex = 1;
            _this.stopFlg = true;
            break;
            case "8": //继续
            _this.tabIndex = 0;
            _this.countdownT = model.countdownT;
            _this.stopFlg = false;
            break;
            case "9": //完成训练
            _this.vibrate();
            _this.isEnd = true;
            _this.page = "9";
            _this.fitTotalDuration = model.fitTotalDuration;
            _this.averHeartRate = _this.getAverHeartRate(_this.heartRateList); //平均心率
            _this.maxHeartRate = _this.getMaxHeartRatet(_this.heartRateList); //最高心率
            _this.acCalorie = model.acCalorie;
            this.quit();
            break;
            case "10": //退出训练
            _this.page = "10";
            this.quit();
            break;
            case "11": //登录中
            _this.page = "11"
            break;
            case "12": //退出登录
            _this.page = "12";
            this.quit();
            break;
            case "13": //进度条
            _this.progress = ((model.acProgress / model.maxProgress) * 350);
            break;
            case "14": //训练总时长
            _this.acCalorie = model.acCalorie ? model.acCalorie : '--';
            _this.fitDuration = model.fitDuration;
            break;
            case "15": //离开或者返回训练
            if (model.rollbackStop == '0') {
                if (_this.lastPage != "") {
                    _this.page = _this.lastPage;
                }
            } else {
                _this.lastPage = _this.page;
                _this.page = "15"
            }
            this.quit();
            break;
            case "16": //杀掉进程
            _this.page = "12";
            this.quit();
            break;
            case "17": //播放初始化、注册心率
            //获取心率
            _this.getHeartRate();
            break;
        }
    },

/**
    发送短消息给客户端
   */
    sendMsg(obj) {
        let _this = this;
        _this.sendFlg = true;
        FeatureAbility.sendMsg({
            deviceId: 'remote',
            bundleName: 'com.sportq.fit',
            message: JSON.stringify(obj),
            success: function () {
                _this.sendFlg = false;
                console.log('sendMsg success.');
            },
            fail: function (data, code) {
                _this.sendFlg = false;
                console.log('handing fail, message: ' + data + ', code: ' + code);
            }
        });
    }

,

/**
  *保持屏幕常亮
  */
    keepScreenOn() {
        brightness.setKeepScreenOn({
            keepScreenOn: true,
            success: function () {
                console.log("handling set keep screen on success")
            },
            fail: function (data, code) {
                console.log("handling set keep screen on fail, code:" + code);
            }
        })
    }

,
/**
  *获取客户端短消息
    */
    getMsg() {
        let _this = this;
        FeatureAbility.subscribeMsg({
            success: function (data) {
                _this.start(JSON.parse(data.message));
            },
            fail: function (data, code) {
                console.log('handing fail, message: ' + data + ', code: ' + code);
            }
        });
    }

,

/**
   * 把错误信息发送至客户端
   */
    sendErrMsg(data, code) {
        FeatureAbility.sendMsg({
            deviceId: 'remote',
            bundleName: 'com.sportq.fit',
            message: JSON.stringify({
                "errData": data,
                "errCode": code,
            }),
            success: function () {
                console.log('sendErrMsg success.');
            },
            fail: function (data, code) {
                console.log('handing fail, message: ' + data + ', code: ' + code);
            }
        });
    }

,
/**
  *获取心率
  */
    getHeartRate() {
        let _this = this;
        sensor.subscribeHeartRate({
            success: function (data) {
                if (data.heartRate != 255) {
                    _this.newHeartRate = data.heartRate;
                    _this.heartRateList.push(data.heartRate);
                    console.log('获取心率成功: ' + data.heartRate);
                } else {
                    _this.newHeartRate = "--";
                }
                _this.sendMsg({
                    "eventFlg": "0",
                    "rateCnt": _this.newHeartRate
                });
            },
            fail: function (data, code) {
                _this.newHeartRate = "--";
                console.log('获取心率失败: ' + data);
                _this.sendErrMsg(data,code)
            }
        })
    }

,
/**
  *计算平均心率
   */
    getAverHeartRate(arr) {
        //将array的长度赋给len
        let len = arr.length;
        let sum = 0;
        //利用for循环遍历数组的内容，利用sum累加求和
        for (let i = 0; i < len; i++) {
            sum += arr[i];
        }
        //返回数组的和与长度求平均值
        return parseInt(sum / len);
    }

,
/**
  *获取最大心率
   */
    getMaxHeartRatet(arr) {
        let max = arr[0];
        for (let i = 0; i < arr.length - 1; i++) {
            max = max < arr[i + 1] ? arr[i + 1] : arr
        }
        return parseInt(max)
    }

,
/**
  *暂停
   */
    stop() {
        this.isStop = true;
        this.stopFlg = true;
        this.tabIndex = 1;
        this.sendMsg({
            "eventFlg": "3",
        })
    }

,
/**
  *播放
   */
    play() {
        this.isStop = false;
        this.stopFlg = false;
        this.sendMsg({
            "eventFlg": "4",
        })
    }

,
/**
  *关闭
   */
    close() {
        this.sendMsg({
            "eventFlg": "5",
        });
        this.quit();
    }

,
/**
  *上一个动作
   */
    previous() {
        this.sendMsg({
            "eventFlg": "1",
        })
    }

,
/**
  *下一个动作
   */
    next() {
        this.sendMsg({
            "eventFlg": "2",
        })
    }

,

/**
  *震动
  */
    vibrate() {
        vibrator.vibrate({
            mode: "short",
            success() {
                console.log("success to vibrate");
            },
            fail(data, code) {
                console.log(`handle fail, data = ${data}, code = ${code}`);
            }
        });
    }

,

/**
    *数据重置
    */
    restore() {
        this.lastPage = "";
        this.isStop = false;
        this.sendFlg = false;
        this.stopFlg = false;
        this.heartRateList = [];
        //取消接收手机侧第三方应用发过来的消息
        FeatureAbility.unsubscribeMsg();
        sensor.unsubscribeHeartRate() //取消监听心率
    }

,
/**
  *退出训练
   */
    quit() {
        this.isStop = false;
        this.sendFlg = false;
        this.stopFlg = false;
        this.heartRateList = [];
        sensor.unsubscribeHeartRate() //取消监听心率
    }

,
/**
  *完成
   */
    end() {
        this.page = '10';
    }
}
