import brightness from '@system.brightness' //保持屏幕常亮
import app from '@system.app' //右滑退出
import router from '@system.router' //页面跳转
import {P2pClient} from '../wearengine'

// 步骤1：创建点对点通信对象
var p2pClient = new P2pClient();

export default {
    data: {
        acCalorie: "0", //卡路里
        fitTotalDuration: "", //训练时长-用于训练完成界面
        averHeartRate: "", //平均心率
        maxHeartRate: "", //最高心率
    },

    onInit() {
        p2pClient.setPeerPkgName("com.sportq.fit");
        p2pClient.setPeerFingerPrint("B1B788A1BBD5F459BC641DA8CE690EA065C96957F58E883764982B5C46E53E06");
    },

    onReady() {
        let _this = this;
        //获取客户端信息
        _this.getMsg();
    },

    onShow() {
        let _this = this;
        //更新页面数据
        _this.acCalorie = _this.endCalorie;
        _this.fitTotalDuration = _this.endTotalTime;
        _this.averHeartRate = _this.endAverHeartRate;
        _this.maxHeartRate = _this.endMaxHeartRate;
        //取消常亮
        brightness.setKeepScreenOn({
            keepScreenOn: false,
            success: function () {
            },
            fail: function (data, code) {
            }
        })
    },

    onDestroy() {
        //取消接收手机侧第三方应用发过来的消息
        console.error("end--onDestroy:unregisterReceiver")
        p2pClient.unregisterReceiver({
            onSuccess: function () {
            },
        });
    },

    start(msg) {
        let _this = this;
        //训练完成页面，只接收重新开始训练事件
        if (msg.eventFlg == "17") {
            router.replace({
                uri: "pages/index/index",
                params: {
                    initPage: "0"
                }
            });
        }
    },

/**
  *获取客户端短消息
    */
    getMsg() {
        let _this = this;
        // 步骤4：接收手机侧第三方应用发过来的简短消息或文件
        var receiver = {
            onSuccess: function () {
                // 处理注册接收手机侧简短消息或文件成功的回调函数
            },
            onFailure: function () {
                // 处理注册接收手机侧简短消息或文件失败的回调函数
            },
            onReceiveMessage: function (data) {
                _this.start(JSON.parse(data));
            },
        }
        p2pClient.registerReceiver(receiver);
    },

/**
  *完成
   */
    end() {
        router.replace({
            uri: "pages/index/index",
            params: {
                initPage: "11"
            }
        });
    },

/**
    *右滑退出
    */
    touchMove: function (e) {
        if (e.direction == "right") {
            app.terminate();
        }
    }
}
