import brightness from '@system.brightness' //保持屏幕常亮
import app from '@system.app' //右滑退出
import router from '@system.router' //页面跳转

export default {
    data: {
        acCalorie: "0", //卡路里
        fitTotalDuration: "", //训练时长-用于训练完成界面
        averHeartRate: "", //平均心率
        maxHeartRate: "", //最高心率
    },
    onReady() {
        let _this = this;
        //获取客户端信息
        _this.getMsg();
        //更新页面数据
        _this.acCalorie = _this.endCalorie;
        _this.fitTotalDuration = _this.endTotalTime;
        _this.averHeartRate = _this.endAverHeartRate;
        _this.maxHeartRate = _this.endMaxHeartRate;
    },
    onShow() {
        //取消常亮
        brightness.setKeepScreenOn({
            keepScreenOn: false,
            success: function () {
            },
            fail: function (data, code) {
            }
        })
    },
    onDestroy() {
        //取消接收手机侧第三方应用发过来的消息
        FeatureAbility.unsubscribeMsg();
    },
    start(msg) {
        let _this = this;
        let model = msg.acModel;
        //训练完成页面，只接收重新开始训练事件
        if (msg.eventFlg == "17") {
            router.replace({
                uri: "pages/index/index",
                params: {
                    initPage: "0"
                }
            });
        }
    },

/**
  *获取客户端短消息
    */
    getMsg() {
        let _this = this;
        FeatureAbility.subscribeMsg({
            success: function (data) {
                _this.start(JSON.parse(data.message));
            },
            fail: function (data, code) {
            }
        });
    },

/**
  *完成
   */
    end() {
        router.replace({
            uri: "pages/index/index",
            params: {
                initPage: "11"
            }
        });
    },

/**
    *右滑退出
    */
    touchMove: function (e) {
        if (e.direction == "right") {
            app.terminate();
        }
    }
}
