import sensor from '@system.sensor'; //传感器
import vibrator from '@system.vibrator'; //震动
import brightness from '@system.brightness' //保持屏幕常亮
import app from '@system.app' //右滑退出
import router from '@system.router' //页面跳转

var timer;

export default {
    data: {
        page: "", //显示页面
        acName: "", //动作名称
        progress: "", //进度条
        acCalorie: "0", //卡路里
        countdownT: "", // 倒计时
        restHint: "", //休息文案
        isLast: "", //是否第一个动作 "0":真 "1":假
        isFirst: "", // 是否最后一个动作 "0":真 "1":假
        fitDuration: "00:00", //训练持续时长
        heartRateList: [], //心率数组
        newHeartRate: "--", //当前心率
        isStop: false, //是否是手表端暂停
        sendFlg: false, // 是否在发送消息
        stopFlg: false, //是否暂停
        tabIndex: 0, //训练数据滑动index
        isPhoneLeave: false, //手机端离开状态
        lastPage: "", //手机端离开训练页面时的页面page
        isJumpLoginPage: true, //是否跳转到未登录提示页
        dataPageShow: false, //训练数据页面是否显示
        canReceiveMessage: true, //是否可以接收手机端其他事件（手表端主动暂停或训练结束后，不再接收除17外的其他事件）
        isFirstInit: true, //是否是第一次初始化事件
    },
    onReady() {
        let _this = this;
        //数据重置
        _this.restore();
        //手机端是否安装了Fit
        _this.checkInstall();
        //获取客户端信息
        _this.getMsg();
        //发送个启动事件
        _this.sendMsg({
            "eventFlg": "6",
        });
        //在数据页面时，重新开启新的课程，跳转到训练页面的场合
        if (_this.initPage == "0" || _this.initPage == "11") {
            _this.isJumpLoginPage = false;
            _this.isFirstInit = false;
            _this.page = _this.initPage;
        }
        //关闭启动页
        setTimeout(function () {
            if (_this.isJumpLoginPage) {
                _this.page = "11";
            }
        },1500);
    },
    onShow() {
        let _this = this;
        //保持屏幕常亮
        _this.keepScreenOn();
        timer = setInterval(function () {
            _this.keepScreenOn();
        },2 * 60 * 1000);
        //重新回到训练界面时，同步一下训练数据及暂停播放状态
        _this.sendMsg({
            "eventFlg": "8",
        });
    },
    onHide() {
        this.stopFlg = true;
        this.tabIndex = 1;
        //消息发送时，手机端可能无法接受消息，所以在onShow时，需要重新同步
        this.sendMsg({
            "eventFlg": "3",
        })
    },
    onDestroy() {
        //发送页面销毁时间
        this.sendMsg({
            "eventFlg": "7",
        });
        this.quit();
        //取消接收手机侧第三方应用发过来的消息
        FeatureAbility.unsubscribeMsg();
    },
    start(msg) {
        let _this = this;
        let model = msg.acModel;

        //手表端主动关闭训练后，不接收除17外的初始化事件，
        if (msg.eventFlg == "17") {
            //数据重置
            _this.init();
            _this.canReceiveMessage = true;
            if (_this.isFirstInit) {
                _this.isFirstInit = false;
                _this.page = "11";
            }
        }
        if (!_this.canReceiveMessage) {
            return;
        }
        //接到手机端消息时(去掉17初始化的事件)，启动页显示完后，不显示提示登录页面page 11
        if (msg.eventFlg != "") {
            _this.isJumpLoginPage = false;
        }
        //手表端正在发送消息，不处理事件
        if (_this.sendFlg) {
            return false;
        }
        //手表端主动暂停的场合，只接受手机端此次返回的暂停事件，防止显示错乱
        if (_this.isStop && msg.eventFlg != "7") {
            return false;
        }
        _this.isStop = false;

        //手机端主动离开训练页面标识，只接受手机端返回事件或者应用退出事件（手机端返回训练页面时，应该还是暂停状态，手表端状态同步）
        if (_this.isPhoneLeave) {
            //只处理返回训练页面、退出训练、杀进程事件
            //1事件是手机端点击左上角关闭按钮，再继续训练的场合
            if (msg.eventFlg != "16" && msg.eventFlg != "15" && msg.eventFlg != "10" && msg.eventFlg != "1") {
                return
            }
            _this.isPhoneLeave = false;
        }
        //手机端返回训练页面
        if (msg.eventFlg == "15" && model.rollbackStop == '0') {
            //获取心率
            _this.getHeartRate();
            //还原暂停状态页面
            if (!_this.dataPageShow) {
                _this.dataPageShow = true;
            }
            _this.tabIndex = 1;
            _this.stopFlg = true;
            //训练数据页面显示的实际数据
            if (_this.lastPage != "") { //有可能是手机离开页面的15事件，手表端没有收到，所以导致lastpage没有值，这时候按训练中的页面算
                _this.page = _this.lastPage;
            }
            if (_this.page != "1" && _this.page != "2" && _this.page != "3" && _this.page != "4" && _this.page != "5" && _this.page != "6" && _this.page != "7" && _this.page != "8") { //其他场合，全都重置页面page
                _this.page = "2";
                _this.acName = "";
            }
            _this.lastPage = "";
            return;
        }
        //手机端离开训练页面，添加标识
        if (msg.eventFlg == "15" && model.rollbackStop != '0') {
            _this.isPhoneLeave = true;
        }
        //训练数据页面是否显示（避免重复添加、移除操作）
        if (msg.eventFlg != "13" && msg.eventFlg != "14") {
            if (msg.eventFlg == "1" || msg.eventFlg == "2" || msg.eventFlg == "3" || msg.eventFlg == "4" || msg.eventFlg == "5" || msg.eventFlg == "6" || msg.eventFlg == "7" || msg.eventFlg == "8") {
                if (!_this.dataPageShow) {
                    _this.dataPageShow = true;
                }
            } else {
                _this.dataPageShow = false;
            }
        }
        switch (msg.eventFlg) {
            case "0": //训练准备
            _this.page = "0";
            _this.tabIndex = "0";
            break;
            case "1": //训练准备后的倒计时
            _this.countdownT = model.countdownT;
            _this.stopFlg = false;
            _this.page = "1";
            break;
            case "2": //动作名称
            _this.vibrate();
            _this.acName = model.acName;
            _this.isLast = model.isLast;
            _this.isFirst = model.isFirst;
            _this.tabIndex = 0;
            _this.stopFlg = false;
            _this.page = "2";
            break;
            case "3": //动作预览
            _this.acName = model.acName;
            _this.page = "3";
            break;
            case "4": //动作预览倒计时
            _this.acName = model.acName;
            _this.countdownT = model.countdownT;
            _this.page = "4";
            break;
            case "5": //训练动作倒计时
            _this.acName = model.acName;
            if (model.acType == "0") {
                _this.countdownT = model.acCnt + "/" + model.acTotalCnt;
            } else {
                _this.countdownT = model.countdownT;
            }
            _this.page = "5";
            break;
            case "6": //休息中
            _this.acName = model.acName;
            _this.countdownT = model.countdownT;
            _this.page = "6";
            break;
            case "7": //暂停
            _this.tabIndex = 1;
            _this.stopFlg = true;
            //如果暂停的时候，正在准备开始训练或倒计时的场合，需要隐藏这个页面
            if (_this.page == "0") {
                _this.page = "2";
            }
            break;
            case "8": //继续
            _this.page = "1";
            _this.tabIndex = 0;
            _this.countdownT = "3";
            _this.stopFlg = false;
            break;
            case "9": //完成训练
            _this.vibrate();
            router.replace({
                uri: "pages/end/end",
                params: {
                    endTotalTime: model.fitTotalDuration, //训练时间
                    endAverHeartRate: _this.getAverHeartRate(_this.heartRateList), //平均心率
                    endMaxHeartRate: _this.getMaxHeartRate(_this.heartRateList), //最高心率
                    endCalorie: model.acCalorie, //消耗心率
                }
            });
            break;
            case "10": //退出训练
            _this.page = "10";
            _this.quit();
            break;
            case "11": //登录中
            _this.page = "11";
            break;
            case "12": //退出登录
            _this.page = "11";
            _this.quit();
            break;
            case "13": //进度条
            _this.progress = ((model.acProgress / model.maxProgress) * 350);
            break;
            case "14": //训练总时长
            _this.acCalorie = model.acCalorie ? model.acCalorie : '--';
            _this.fitDuration = model.fitDuration;
            _this.stopFlg = model.stopFlag; //同步状态
            break;
            case "15": //离开或者返回训练
            if (model.rollbackStop == '0') {
                //获取心率
                _this.getHeartRate();
            } else {
                _this.lastPage = _this.page;
                _this.page = "15";
                //移除心率监听
                sensor.unsubscribeHeartRate() //取消监听心率
            }
            break;
            case "16": //杀掉进程
            _this.page = "11";
            _this.quit();
            break;
            case "17": //播放初始化、注册心率
            //获取心率
            _this.getHeartRate();
            break;
        }
    },

/**
     * 检测对端设备侧是否已经安装指定应用
     */
    checkInstall() {
        let _this = this;
        FeatureAbility.detect({
            bundleName: 'com.sportq.fit',
            success: function () {
                //已安装
            },
            fail: function (data, code) {
                if (!data && !code) { //未安装
                    _this.page = "99";
                    _this.isJumpLoginPage = false;
                }
            },
        });
    },


/**
    发送短消息给客户端
   */
    sendMsg(obj) {
        let _this = this;
        _this.sendFlg = true;
        FeatureAbility.sendMsg({
            deviceId: 'remote',
            bundleName: 'com.sportq.fit',
            message: JSON.stringify(obj),
            success: function () {
                _this.sendFlg = false;
                console.log('sendMsg success.');
            },
            fail: function (data, code) {
                _this.sendFlg = false;
                console.log('handing fail, message: ' + data + ', code: ' + code);
            }
        });
    },

/**
    发送心率消息
   */
    sendHeartRateMsg(obj) {
        let _this = this;
        FeatureAbility.sendMsg({
            deviceId: 'remote',
            bundleName: 'com.sportq.fit',
            message: JSON.stringify(obj),
            success: function () {
            },
            fail: function (data, code) {
            }
        });
    },

/**
  *保持屏幕常亮
  */
    keepScreenOn() {
        brightness.setKeepScreenOn({
            keepScreenOn: true,
            success: function () {
            },
            fail: function (data, code) {
            }
        })
    }

,
/**
  *获取客户端短消息
    */
    getMsg() {
        let _this = this;
        FeatureAbility.subscribeMsg({
            success: function (data) {
                _this.start(JSON.parse(data.message));
            },
            fail: function (data, code) {
            }
        });
    }

,
/**
  *获取心率
  */
    getHeartRate() {
        let _this = this;
        sensor.subscribeHeartRate({
            success: function (data) {
                if (data.heartRate != 255) {
                    _this.newHeartRate = data.heartRate;
                    _this.heartRateList.push(data.heartRate);
                } else {
                    _this.newHeartRate = "--";
                }
                _this.sendHeartRateMsg({
                    "eventFlg": "0",
                    "rateCnt": _this.newHeartRate
                });
            },
            fail: function (data, code) {
                _this.newHeartRate = "--";
            }
        })
    },

/**
  *计算平均心率
   */
    getAverHeartRate(arr) {
        if (arr.length > 0) {
            //将array的长度赋给len
            let len = arr.length;
            let sum = 0;
            //利用for循环遍历数组的内容，利用sum累加求和
            for (let i = 0; i < len; i++) {
                sum += arr[i];
            }
            //返回数组的和与长度求平均值
            return parseInt(sum / len);
        } else {
            return "--"
        }
    }

,
/**
  *获取最大心率
   */
    getMaxHeartRate(arr) {
        if (arr.length > 0) {
            let max = arr[0];
            for (let i = 0; i < arr.length; i++) {
                if (arr[i] > max) {
                    max = arr[i];
                }
            }
            return parseInt(max)
        } else {
            return "--"
        }
    },


/**
  *暂停
   */
    stop() {
        this.isStop = true;
        this.stopFlg = true;
        this.tabIndex = 1;
        this.sendMsg({
            "eventFlg": "3",
        })
    },


/**
  *播放
   */
    play() {
        this.tabIndex = 0;
        this.isStop = false;
        this.stopFlg = false;
        this.sendMsg({
            "eventFlg": "4",
        })
    },


/**
  *关闭
   */
    close() {
        this.canReceiveMessage = false;
        this.dataPageShow = false;
        this.page = "10";
        this.sendMsg({
            "eventFlg": "5",
        });
        this.quit();
    },


/**
  *上一个动作
   */
    previous() {
        this.sendMsg({
            "eventFlg": "1",
        })
    },


/**
  *下一个动作
   */
    next() {
        this.sendMsg({
            "eventFlg": "2",
        })
    },

/**
  *介绍页开始训练
   */
    introStart() {
        this.page = "98";
        this.tabIndex = 0;
    },

/**
  *震动
  */
    vibrate() {
        vibrator.vibrate({
            mode: "short",
            success() {
            },
            fail(data, code) {
            }
        });
    },

/**
    *数据重置
    */
    restore() {
        this.isFirstInit = true;
        this.isStop = false;
        this.canReceiveMessage = true;
        this.sendFlg = false;
        this.stopFlg = false;
        this.isLast = "", //是否第一个动作 "0":真 "1":假
        this.isFirst = "", // 是否最后一个动作 "0":真 "1":假
        this.acName = "";
        this.fitDuration = "00:00";
        this.progress = "", //进度条
        this.countdownT = "", // 倒计时
        this.heartRateList = [];
        //取消接收手机侧第三方应用发过来的消息
        FeatureAbility.unsubscribeMsg();
        sensor.unsubscribeHeartRate() //取消监听心率
    },


/**
    *数据重置
    */
    init() {
        this.isStop = false;
        this.sendFlg = false;
        this.stopFlg = false;
        this.isPhoneLeave = false;
        this.acCalorie = "0";
    },

/**
  *退出训练
   */
    quit() {
        this.isStop = false;
        this.sendFlg = false;
        this.stopFlg = false;
        this.isLast = "", //是否第一个动作 "0":真 "1":假
        this.isFirst = "", // 是否最后一个动作 "0":真 "1":假
        this.acName = "";
        this.fitDuration = "00:00";
        this.progress = "", //进度条
        this.countdownT = "", // 倒计时
        this.newHeartRate = "--", //当前心率
        this.heartRateList = [];
        sensor.unsubscribeHeartRate() //取消监听心率
        if (timer != null) {
            clearInterval(timer);
        }
    },

/**
    *swiper滑动
    */
    swiperChange(index) {
        this.tabIndex = index.index;
    },

/**
    *右滑退出
    */
    touchMove: function (e) {
        if (e.direction == "right") {
            app.terminate();
        }
    }
}
